/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;

public class FocusView
extends ObjectView
implements ActionListener {
    private JLabel maFocused;
    private JButton maGrabFocus;
    private XAccessibleComponent mxComponent;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        if (xAccessibleComponent != null) {
            return new FocusView(objectViewContainer);
        }
        return null;
    }

    public FocusView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.maFocused = new JLabel();
        this.maFocused.setFont(this.GetContainer().GetViewFont());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.maFocused, gridBagConstraints);
        this.maGrabFocus = new JButton("grabFocus");
        this.maGrabFocus.setFont(this.GetContainer().GetViewFont());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.maGrabFocus, gridBagConstraints);
        this.maGrabFocus.addActionListener(this);
    }

    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        super.SetObject(xAccessibleContext);
    }

    public synchronized void Destroy() {
        super.Destroy();
        this.maGrabFocus.removeActionListener(this);
    }

    public synchronized void Update() {
        if (this.mxContext == null) {
            this.maFocused.setText("<null object>");
            this.maGrabFocus.setEnabled(false);
        } else {
            XAccessibleStateSet xAccessibleStateSet = this.mxContext.getAccessibleStateSet();
            if (xAccessibleStateSet.contains((short)11)) {
                this.maFocused.setText("focused");
            } else {
                this.maFocused.setText("not focused");
            }
            if (this.maGrabFocus != null) {
                this.maGrabFocus.setEnabled(true);
            }
        }
    }

    public String GetTitle() {
        return "Focus";
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("grabFocus")) {
            this.mxComponent.grabFocus();
        }
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        System.out.println(accessibleEventObject);
        if (accessibleEventObject.EventId == 4) {
            this.Update();
        }
    }
}

